/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateArcStartEndCenter.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CLine.h"
#include "CApplication.h"

//	Creates an arc using the start, end and center points
//	calculates the radius of the arc
//	Returns the arc created
//	After creation the arc is AutoConstrained.

HRESULT CreateArcStartEndCenter(IPoint *startPoint, IPoint *endPoint, IPoint *center,
																ILine **dArc1)
{

	START_METHOD("CreateArcStartEndCenter")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get geometric interface
	IGeometric *geometric = CAST(IGeometric, activeWorkplane);

	// Get zPlane
	IGeometry *pGeometry = NULL;
	status = geometric->GetGeometry(&pGeometry);
	CHECK_RETURN_STATUS(status)

	IPlane *plane = CAST(IPlane, pGeometry);

	// Get startVector
	IVector *startVector3D = NULL;
	status = startPoint->GetPosition(&startVector3D);
	CHECK_RETURN_STATUS(status)

	// Get endVector
	IVector *endVector3D = NULL;
	status = endPoint->GetPosition(&endVector3D);
	CHECK_RETURN_STATUS(status)

	// Get centerVector
	IVector *centerVector3D = NULL;
	status = center->GetPosition(&centerVector3D);
	CHECK_RETURN_STATUS(status)

	// Get the 2D vector for startVector
	IVector *startVector2D = NULL;
	status = activeWorkplane->Get2DVector(startVector3D, &startVector2D);
	CHECK_RETURN_STATUS(status)

	// Get the 2D vector for centerVector
	IVector *centerVector2D = NULL;
	status = activeWorkplane->Get2DVector(centerVector3D, &centerVector2D);
	CHECK_RETURN_STATUS(status)

	// Get radius vector
	IVector *radiusVector2D = NULL;
	status = centerVector2D->subtract(CAST(IVectorOrDirection, startVector2D), &radiusVector2D);
	CHECK_RETURN_STATUS(status)

	// Get radius
	double radius;	
	status = radiusVector2D->GetMagnitude(&radius);
	CHECK_RETURN_STATUS(status)

	// Get normal to the plane
	IDirection *normal = NULL;
	status = plane->GetNormal(&normal);
	CHECK_RETURN_STATUS(status)

	// Create basic circular arc
	IBasicCircularArc *curve1 = NULL;
	status = (GetCLASS(BasicCircularArc))->CreateBasicCircularArc(centerVector3D, normal,
		radius, startVector3D, endVector3D, &curve1);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *arc1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve1), &arc1);
	CHECK_RETURN_STATUS(status)
	*dArc1 = arc1;

	// Apply AutoConstrain on the line created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, arc1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the arc created
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, arc1));
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateArcStartEndCenter")
}
